import matplotlib.pyplot as plt
import seaborn as sns
import os
from sklearn.preprocessing import LabelEncoder
from sklearn.model_selection import train_test_split
from sklearn.metrics import classification_report, confusion_matrix
from sklearn.linear_model import LogisticRegression
from sklearn.metrics import accuracy_score
from sklearn.preprocessing import StandardScaler
from sklearn.cluster import KMeans
from sklearn.metrics import silhouette_score
import numpy as np
from scipy import stats
import sys
sys.path.append(sys.argv[1])

import pandas as pd   
import pickle


# Load the dataset    
fastfood = pd.read_csv(os.path.join(sys.argv[1], 'fastfood.csv'))  

# Assuming the dataset is loaded as a DataFrame named 'fastfood'   
keywords = ['sandwich', 'wrap', 'salad', 'burger', 'burrito', 'taco']   
   
# Make the filtering case-insensitive   
fastfood['item_lower'] = fastfood['item'].str.lower()   
   
# Filter the dataset using the keywords   
filtered_fastfood = fastfood[fastfood['item_lower'].str.contains('|'.join(keywords))]   
   
# Drop the 'item_lower' column as it's not needed anymore   
filtered_fastfood = filtered_fastfood.drop(columns=['item_lower'])   

print(filtered_fastfood)
# pickle.dump(filtered_fastfood,open("./ref_result/filtered_fastfood.pkl","wb"))


